package {{packageName}}.{{module}}.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.math.BigInteger;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.util.ObjectUtils;
import org.springframework.util.DigestUtils;
import {{packageName}}.util.domain.EntityBase;
import {{packageName}}.util.annotation.DEField;
import {{packageName}}.util.enums.DEPredefinedFieldType;
import {{packageName}}.util.enums.DEFieldDefaultValueType;
import {{packageName}}.util.helper.DataObject;
import {{packageName}}.util.annotation.Audit;
import {{packageName}}.util.enums.DupCheck;
import {{packageName}}.util.domain.EntityMP;
import java.io.Serializable;
import lombok.*;
import org.springframework.data.annotation.Transient;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.baomidou.mybatisplus.annotation.*;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;

@Getter
@Setter
@NoArgsConstructor
@Accessors(chain = true)
@JsonIgnoreProperties(value = "handler")
@TableName(value = "{{entity.tableName}}", resultMap = "{{entity.codeName}}ResultMap")
@ApiModel("{{entity.logicName}}{{entity.enableAPIStorage}}")
public class {{entity.codeName}} extends EntityMP implements Serializable
{

    {{#entity.fields}}
    {{^deepStructure}}
    /**
     * {{logicName}}
     */
    {{#keyDEField}}
    {{#phisicalDEField}}
    @TableId(value = "{{columnName}}"{{#type.number}} , type = IdType.ASSIGN_ID{{/type.number}}{{#type.string}} , type = IdType.ASSIGN_UUID{{/type.string}})
    {{/phisicalDEField}}
    {{/keyDEField}}
    {{^keyDEField}}
    @TableField(value = "{{columnName}}"{{#insertOnly}} , fill = FieldFill.INSERT{{/insertOnly}}{{^phisicalDEField}} , exist = false{{/phisicalDEField}})
    {{#logicValidField}}
    @TableLogic{{#validLogicValue}}(value = "{{validLogicValue}}"{{#invalidLogicValue}} , delval = "{{invalidLogicValue}}"{{/invalidLogicValue}}){{/validLogicValue}}
    {{/logicValidField}}
    {{/keyDEField}}
    {{#enableAudit}}
    @Audit
    {{/enableAudit}}
    @Defield({{annotation}})
    @JsonProperty("{{jsonName}}")
    {{#timeType}}
    @JsonFormat(pattern = "{{format}}", locale = "zh", timezone = "GMT+8")
    {{/timeType}}
    @JSONField(name = "{{jsonName}}"{{#timeType}} , format = "{{format}}"{{/timeType}})
    @ApiModelProperty("{{logicName}}")
    private {{type.java}} {{codeName.camelCase}};

    {{/deepStructure}}
    {{/entity.fields}}

    {{#entity.references}}
    /**
     * {{entityLogicName}}
     */
    @JsonIgnore
    @JSONField(serialize = false)
    @TableField(exist = false)
    private {{packageName}}.core.{{module}}.domain.{{entityCodeName}} {{codeName.camelCase}};
    {{/entity.references}}

    {{#entity.nesteds}}
    /**
     * {{entityLogicName}}
     */
    {{#listCode}}
    @JSONField(name = "{{listCode}}")
    @JsonProperty("{{listCode}}")
    {{/listCode}}
    {{^listCode}}
    @JsonIgnore
    @JSONField(serialize = false)
    {{/listCode}}
    {{#columnName}}
    @TableField(value = "{{columnName}}" , typeHandler = {{packageName}}.core.{{module}}.domain.handlers.{{entityCodeName}}TypeHandler.class)
    {{/columnName}}
    {{^columnName}}
    @TableField(exist = false)
    {{/columnName}}
    private List<{{packageName}}.core.{{module}}.domain.{{entityCodeName}}> {{codeName.camelCase}};
    {{/entity.nesteds}}

    {{#entity.fields}}
    {{^deepStructure}}
    {{^keyDEField}}
    {{^predefinedType}}
    /**
     * 设置 [{{logicName}}]
     */
    public {{entity.codeName}} set{{codeName.pascalCase}}({{type.java}} {{codeName.camelCase}}) {
        this.{{codeName.camelCase}} = {{codeName.camelCase}};
        this.modify("{{name.lowerCase}}", {{codeName.camelCase}});
        return this;
    }
    {{/predefinedType}}
    {{/keyDEField}}
    {{#timeType}}
    /**
     * 格式化日期 [{{logicName}}]
     */
    public String format{{codeName.pascalCase}}() {
        if (this.{{codeName.camelCase}} == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("{{format}}");
        return sdf.format({{codeName.camelCase}});
    }
    {{/timeType}}

    {{/deepStructure}}
    {{/entity.fields}}

    {{#entity.nesteds}}
    {{#columnName}}
    /**
     * 设置 [{{entityLogicName}}]
     */
    public {{entity.codeName}} set{{codeName.pascalCase}}(List<{{packageName}}.core.{{module}}.domain.{{entityCodeName}}> {{codeName.camelCase}}) {
        this.{{codeName.camelCase}} = {{codeName.camelCase}};
        this.modify("{{columnName}}", ({{codeName.camelCase}}!=null)?{{codeName.camelCase}}:(new ArrayList()));
        return this;
    }
    {{/columnName}}
    
    {{/entity.nesteds}}

    {{#unionKeyMode}}

    {{/unionKeyMode}}
}